const cors = require('cors');
const path = require('path');
const logger = require('morgan');
const express = require('express');
const cookieParser = require('cookie-parser');

// const indexRouter = require('./app/routes/index');
// rutas para tablas independientes
const rolRouter = require('./prisma/routes/rol.routes');
const estadoRouter = require('./prisma/routes/estado.routes');
const habilitadoRouter = require('./prisma/routes/enable.routes');
const unidadorganicaRouter = require('./prisma/routes/unidadorganica.routes');
// rutas para tablas dependientes
const usuarioRouter = require('./prisma/routes/usuario.routes');
const horarioRouter = require('./prisma/routes/horario.routes');
const auditoriaRouter = require('./prisma/routes/auditoria.routes');
const firmadigitalRouter = require('./prisma/routes/firmadigital.routes');
const historiadepuradaRouter = require('./prisma/routes/historiadepurada.routes');
const historiaincautadaRouter = require('./prisma/routes/historiaincautada.routes');
const historiafedateadaRouter = require('./prisma/routes/historiafedateada.routes');
const registrofedatarioRouter = require('./prisma/routes/registrofedateo.routes');

const app = express();
app.use(cors());
app.use(express.json());
app.use(
  express.urlencoded(
    {
      extended: false
    }
  )
);
app.use(cookieParser());
app.use(logger('dev'));

// Set up a more restrictive CORS policy with a list of allowed URLs
// const allowedOrigins = [
//     'https://example.com',
//     'https://subdomain.example.com'
// ];
// app.use(function(req, res, next) {
//     const origin = req.headers.origin;
//     if (allowedOrigins.includes(origin)) {
//         res.header("Access-Control-Allow-Origin", origin);
//     }
//     res.header("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
//     res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
//     next();
// });

// Capture the client's IP address
// app.use(function(req, res, next) {
//     const clientIp = req.headers['x-forwarded-for'] || req.connection.remoteAddress;
//     console.log(`Client IP address: ${clientIp}`);
//     next();
// });

app.use(
  '/',
  express.static(
    path.join(
      __dirname,
      'public'
    )
  )
);

// app.use(
//   '/live',
//   indexRouter
// );
// rutas para tablas independientes
app.use(
  '/habilitado',
  habilitadoRouter
);
app.use(
  '/estado',
  estadoRouter
);
app.use(
  '/unidadorganica',
  unidadorganicaRouter
);
app.use(
  '/rol',
  rolRouter
);
// rutas para tablas dependientes
app.use(
  '/usuario',
  usuarioRouter
);
app.use(
  '/firmadigital',
  firmadigitalRouter
);
app.use(
  '/auditoria',
  auditoriaRouter
);
app.use(
  '/horario',
  horarioRouter
);
app.use(
  '/historiadepurada',
  historiadepuradaRouter
);
app.use(
  '/historiaincautada',
  historiaincautadaRouter
);
app.use(
  '/historiafedateada',
  historiafedateadaRouter
);
app.use(
  '/registrofedatario',
  registrofedatarioRouter
);

module.exports = app;