const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const AuditoriaController = {
  async createAuditoria(req, res) {
    try {
      const { RegistroId, Table, Action, Resume, Detail, Interactiondate, UsuarioId } = req.body;
      const auditoria = await prisma.auditoria.create(
        {
          data: { RegistroId, Table, Action, Resume, Detail, Interactiondate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Auditoria creada correctamente',
          data: auditoria
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Auditoria',
          err: error
        }
      );
    }
  },

  async getAllAuditorias(req, res) {
    try {
      const auditorias = await prisma.auditoria.findMany();
      if (auditorias.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Auditorias',
            data: auditorias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Auditorias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Auditorias',
          err: error
        }
      );
    }
  },

  async usuarioAuditoria(req, res) {
    try {
      const { codigo } = req.params;
      const auditorias = await prisma.auditoria.findMany(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      if (auditorias.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Auditorias de la Empresa indicada',
            data: auditorias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Auditorias registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Auditorias',
          err: error
        }
      );
    }
  },

  async getAuditoriaById(req, res) {
    try {
      const { id } = req.params;
      const auditoria = await prisma.auditoria.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (auditoria !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Auditoria encontrada',
            data: auditoria
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Auditoria con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Auditoria',
          err: error
        }
      );
    }
  },

  async updateAuditoria(req, res) {
    try {
      const { id } = req.params;
      const { RegistroId, Table, Action, Resume, Detail, Interactiondate, UsuarioId } = req.body;
      const auditoria = await prisma.auditoria.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { RegistroId, Table, Action, Resume, Detail, Interactiondate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Auditoria actualizada correctamente',
          data: auditoria
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Auditoria',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Auditoria
  // async deleteAuditoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.auditoria.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Auditoria eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Auditoria',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = AuditoriaController;
