const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();

const EnableContEnableler = {
  async createEnable(req, res) {
    try {
      const { Name } = req.body;
      const habilitado = await prisma.enabled.create(
        { data: { Name } }
      );
      res.json(
        {
          status: 'success',
          msj: 'Enable creada correctamente',
          data: habilitado
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Enable',
          err: error
        }
      );
    }
  },

  async getAllEnables(req, res) {
    try {
      const habilitados = await prisma.enabled.findMany();
      if (habilitados.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Enables',
            data: habilitados
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Enables registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Enables',
          err: error
        }
      );
    }
  },

  async getEnableById(req, res) {
    try {
      const { id } = req.params;
      const habilitado = await prisma.enabled.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (habilitado !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Enable encontrada',
            data: habilitado
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Enable con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Enable',
          err: error
        }
      );
    }
  },

  async updateEnable(req, res) {
    try {
      const { id } = req.params;
      const { Name } = req.body;
      const habilitado = await prisma.enabled.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Enable actualizada correctamente',
          data: habilitado
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Enable',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Enable
  // async deleteEnable(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.enabled.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Enable eliminada'
  //       }
  //     );
  //   } catch (error) {
      // console.log(error);
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Enable',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = EnableContEnableler;
