const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const FirmaDigitalController = {
  async createFirmaDigital(req, res) {
    try {
      const { FirmaDigital, UsuarioId } = req.body;
      const firmadigital = await prisma.firmaDigital.create(
        {
          data: { FirmaDigital, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'FirmaDigital creada correctamente',
          data: firmadigital
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la FirmaDigital',
          err: error
        }
      );
    }
  },

  async getAllFirmaDigitals(req, res) {
    try {
      const firmasdigitales = await prisma.firmaDigital.findMany();
      if (firmasdigitales.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de FirmaDigitals',
            data: firmasdigitales
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay FirmaDigitals registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de FirmaDigitals',
          err: error
        }
      );
    }
  },

  async getFirmaDigitalByUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const firmadigital = await prisma.firmaDigital.findUnique(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      if (firmadigital !== null) {
        res.json(
          {
            status: 'success',
            msj: 'FirmaDigital encontrada',
            data: firmadigital
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la FirmaDigital con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Firma Digital',
          err: error
        }
      );
    }
  },

  async getFirmaDigitalById(req, res) {
    try {
      const { id } = req.params;
      const firmadigital = await prisma.firmaDigital.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (firmadigital !== null) {
        res.json(
          {
            status: 'success',
            msj: 'FirmaDigital encontrada',
            data: firmadigital
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la FirmaDigital con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la FirmaDigital',
          err: error
        }
      );
    }
  },

  async updateFirmaDigital(req, res) {
    try {
      const { id } = req.params;
      const { FirmaDigital, UsuarioId } = req.body;
      const firmadigital = await prisma.firmaDigital.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { FirmaDigital, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'FirmaDigital actualizada correctamente',
          data: firmadigital
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la FirmaDigital',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una FirmaDigital
  // async deleteFirmaDigital(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.firmaDigital.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'FirmaDigital eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la FirmaDigital',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = FirmaDigitalController;
