const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const HistoriaIncautadaController = {
  async createHistoria(req, res) {
    try {
      const { Name, LastName, ClinicHistory, 
        Document, LastVisitDate, UsuarioId } = req.body;
      const historia = await prisma.historiaIncautada.create(
        {
          data: { Name, LastName, ClinicHistory, 
            Document, LastVisitDate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia creada correctamente',
          data: historia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Historia',
          err: error
        }
      );
    }
  },

  async getAllHistorias(req, res) {
    try {
      const historias = await prisma.historiaIncautada.findMany();
      if (historias.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Historias',
            data: historias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Historias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Historias',
          err: error
        }
      );
    }
  },

  async getHistoriaByLastName(req, res) {
    try {
      const { apellido } = req.params;
      const historias = await prisma.historiaIncautada.findMany(
        {
          where: {
            LastName: apellido
          }
        }
      );
      if (historias.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: historias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async getHistoriaById(req, res) {
    try {
      const { id } = req.params;
      const historia = await prisma.historiaIncautada.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (historia !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: historia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async getHistoriaByNumero(req, res) {
    try {
      const { codigo } = req.params;
      const historia = await prisma.historiaIncautada.findUnique(
        {
          where: {
            ClinicHistory: parseInt(codigo)
          }
        }
      );
      if (historia !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: historia
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async updateHistoria(req, res) {
    try {
      const { id } = req.params;
      const { Name, LastName, ClinicHistory, 
        Document, LastVisitDate, UsuarioId } = req.body;
      const historia = await prisma.historiaIncautada.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name, LastName, ClinicHistory, 
            Document, LastVisitDate, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia actualizada correctamente',
          data: historia
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Historia',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Historia
  // async deleteHistoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.historiaIncautada.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Historia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Historia',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = HistoriaIncautadaController;
