const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const HorarioController = {
  async createHorario(req, res) {
    try {
      const { Mes, Anio, FechaSubida, NombreArchivo, UsuarioId, UnidadOrganicaId } = req.body;
      const Horario = await prisma.Horario.create(
        {
          data: { Mes, Anio, FechaSubida, NombreArchivo, UsuarioId, UnidadOrganicaId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Horario creada correctamente',
          data: Horario
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Horario',
          err: error
        }
      );
    }
  },

  async getAllHorarios(req, res) {
    try {
      const Horarios = await prisma.Horario.findMany();
      if (Horarios.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Horarios',
            data: Horarios
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Horarios registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Horarios',
          err: error
        }
      );
    }
  },

  async getHorarioByUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const Horarios = await prisma.Horario.findMany(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      if (Horarios.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Horarios de la Empresa indicada',
            data: Horarios
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Horarios registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Horarios',
          err: error
        }
      );
    }
  },

  async getHorarioByUnidadOrganica(req, res) {
    try {
      const { codigo } = req.params;
      const Horarios = await prisma.Horario.findMany(
        {
          where: {
            UnidadOrganicaId: parseInt(codigo)
          }
        }
      );
      if (Horarios.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Horarios de la Empresa indicada',
            data: Horarios
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Horarios registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Horarios',
          err: error
        }
      );
    }
  },

  async getHorarioById(req, res) {
    try {
      const { id } = req.params;
      const Horario = await prisma.Horario.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (Horario !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Horario encontrada',
            data: Horario
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Horario con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Horario',
          err: error
        }
      );
    }
  },

  async updateHorario(req, res) {
    try {
      const { id } = req.params;
      const { Mes, Anio, FechaSubida, NombreArchivo, UsuarioId, UnidadOrganicaId } = req.body;
      const Horario = await prisma.Horario.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Mes, Anio, FechaSubida, NombreArchivo, UsuarioId, UnidadOrganicaId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Horario actualizada correctamente',
          data: Horario
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Horario',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Horario
  // async deleteHorario(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.Horario.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Horario eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Horario',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = HorarioController;
