const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const RegistroFedatarioController = {
  async createHistoria(req, res) {
    try {
      const { DateFeeding, ClinicHistory, Name, LastName, RecordNumber, 
        Folios, Description, Responsible, DNIResponsible, Document, 
        DocumentPath, SignatureFedatario, SignatureResponsible, UsuarioId } = req.body;
      const registro = await prisma.registroFedatario.create(
        {
          data: { DateFeeding, ClinicHistory, Name, LastName, RecordNumber, 
            Folios, Description, Responsible, DNIResponsible, Document, 
            DocumentPath, SignatureFedatario, SignatureResponsible, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia creada correctamente',
          data: registro
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Historia',
          err: error
        }
      );
    }
  },

  async getAllHistorias(req, res) {
    try {
      const registros = await prisma.registroFedatario.findMany();
      if (registros.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Historias',
            data: registros
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Registro fedatario'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Historias',
          err: error
        }
      );
    }
  },

  async getHistoriaById(req, res) {
    try {
      const { id } = req.params;
      const registro = await prisma.registroFedatario.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (registro !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: registro
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async getHistoriaByNumero(req, res) {
    try {
      const { codigo } = req.params;
      const registro = await prisma.registroFedatario.findUnique(
        {
          where: {
            ClinicHistory: parseInt(codigo)
          }
        }
      );
      if (registro !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Historia encontrada',
            data: registro
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Historia con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Historia',
          err: error
        }
      );
    }
  },

  async updateHistoria(req, res) {
    try {
      const { id } = req.params;
      const { DateFeeding, ClinicHistory, Name, LastName, RecordNumber, 
        Folios, Description, Responsible, DNIResponsible, Document, 
        DocumentPath, SignatureFedatario, SignatureResponsible, UsuarioId } = req.body;
      const registro = await prisma.registroFedatario.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { DateFeeding, ClinicHistory, Name, LastName, RecordNumber, 
            Folios, Description, Responsible, DNIResponsible, Document, 
            DocumentPath, SignatureFedatario, SignatureResponsible, UsuarioId }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Historia actualizada correctamente',
          data: registro
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Historia',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Historia
  // async deleteHistoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.registroFedatario.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Historia eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Historia',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = RegistroFedatarioController;
