const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const RolController = {
  async createRol(req, res) {
    try {
      const { Name, Functions } = req.body;
      const rol = await prisma.rol.create(
        { data: { Name, Functions } }
      );
      res.json(
        {
          status: 'success',
          msj: 'Rol creada correctamente',
          data: rol
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Rol',
          err: error
        }
      );
    }
  },

  async getAllRols(req, res) {
    try {
      const roles = await prisma.rol.findMany();
      if (roles.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Rols',
            data: roles
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Rols registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Rols',
          err: error
        }
      );
    }
  },

  async getRolById(req, res) {
    try {
      const { id } = req.params;
      const rol = await prisma.rol.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (rol !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Rol encontrada',
            data: rol
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Rol con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Rol',
          err: error
        }
      );
    }
  },

  async updateRol(req, res) {
    try {
      const { id } = req.params;
      const { Name, Functions } = req.body;
      const rol = await prisma.rol.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name, Functions }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Rol actualizada correctamente',
          data: rol
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Rol',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Rol
  // async deleteRol(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.rol.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Rol eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Rol',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = RolController;
