const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const UnidadOrganicaController = {
  async createUnidadOrganica(req, res) {
    try {
      const { Name } = req.body;
      const unidadorganica = await prisma.unidadOrganica.create(
        { data: { Name } }
      );
      res.json(
        {
          status: 'success',
          msj: 'Unidad Organica creada correctamente',
          data: unidadorganica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Unidad Organica',
          err: error
        }
      );
    }
  },

  async getAllUnidadOrganicas(req, res) {
    try {
      const unidadorganicas = await prisma.unidadOrganica.findMany();
      if (unidadorganicas.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de Unidad Organicas',
            data: unidadorganicas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay Unidad Organicas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Unidad Organicas',
          err: error
        }
      );
    }
  },

  async getUnidadOrganicaById(req, res) {
    try {
      const { id } = req.params;
      const unidadorganica = await prisma.unidadOrganica.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (unidadorganica !== null) {
        res.json(
          {
            status: 'success',
            msj: 'Unidad Organica encontrada',
            data: unidadorganica
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la Unidad Organica con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Unidad Organica',
          err: error
        }
      );
    }
  },

  async updateUnidadOrganica(req, res) {
    try {
      const { id } = req.params;
      const { Name } = req.body;
      const unidadorganica = await prisma.unidadOrganica.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'Unidad Organica actualizada correctamente',
          data: unidadorganica
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Unidad Organica',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una UnidadOrganica
  // async deleteUnidadOrganica(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.unidadOrganica.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'Unidad Organica eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Unidad Organica',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = UnidadOrganicaController;
