const XLSX = require("xlsx");
const { PrismaClient } = require('@prisma/client');
const prisma = new PrismaClient();
// array para almacenar los datos
const jDatos = [];
// array para los depurados
const depurados = [];
// array para los fedateados
const fedateados = [];
// array para los incautados
const incautados = [];
function numeroAFecha(numeroDeDias, esExcel = false) {
    let diasDesde1900 = esExcel ? 25567 + 1 : 25567;
    // 86400 es el número de segundos en un día, luego multiplicamos por 1000 para obtener milisegundos.
    return new Date((numeroDeDias - (diasDesde1900+1)) * 86400 * 1000);
}

const excel = XLSX.readFile(
    // ruta del archivo excel
    "./reporte17042023pre.xlsx"
  );
  var nombreHoja = excel.SheetNames; // regresa un array
  let datos = XLSX.utils.sheet_to_json(
    excel.Sheets[
        nombreHoja[0]
        ]
    );
  for (let i = 0; i < datos.length; i++) {
    const dato = datos[i];
    jDatos.push({
      ...dato
    });
  }



async function seed() {
    console.log('Iniciando la insercion de datos en las tablas');
    console.log('-----------------------------');
    console.log('------------depurados-----------');
    for (const datadepurado of depurados) {
        await prisma.enabled.create({data: datadepurado});
    }
    console.log('------------fedateados-----------');
    for (const datafedateado of fedateados) {
        await prisma.state.create({data: datafedateado});
    }
    console.log('------------incautados-----------');
    for (const dataincautado of incautados) {
        await prisma.rol.create({data: dataincautado});
    }
    console.log('-----------------------------');
    console.log('Insercion de datos a las tablas finalizado');
    // );
}

seed()
    .catch(
        (e) => {
            console.error(e)
            process.exit(1)
        }
    )
    .finally(
        async () => {
            await prisma.$disconnect()
        }
    )