const express = require('express');
const router = express.Router();
const EnableController = require('../controllers/enable.controller');

// GET all Enables
router.get('/', EnableController.getAllEnables);

// GET Enable by id
router.get('/:id', EnableController.getEnableById);

// POST a new Enable
router.post('/', EnableController.createEnable);

// PUT update an existing Enable
router.put('/update/:id', EnableController.updateEnable);

// DELETE an existing Enable
// muy probable no considerar esta opción
// router.delete('/:id', EnableController.deleteEnable);

module.exports = router;
