const express = require('express');
const router = express.Router();
const RegistroFedateadaController = require('../controllers/registrofedatario.controller');

// GET all Historias
router.get('/', RegistroFedateadaController.getAllHistorias);

// GET Historia by id
router.get('/:id', RegistroFedateadaController.getHistoriaById);

// POST a new Historia
router.post('/', RegistroFedateadaController.createHistoria);

// PUT update an existing Historia
router.put('/update/:id', RegistroFedateadaController.updateHistoria);

// DELETE an existing Historia
// muy probable no considerar esta opción
// router.delete('/:id', RegistroFedateadaController.deleteHistoria);

// para los filtros por tipo
router.get('/numero/:codigo', RegistroFedateadaController.getHistoriaByNumero);

module.exports = router;
