const express = require('express');
const router = express.Router();
const UnidadOrganicaController = require('../controllers/unidadorganica.controller');

// GET all UnidadOrganicas
router.get('/', UnidadOrganicaController.getAllUnidadOrganicas);

// GET UnidadOrganica by id
router.get('/:id', UnidadOrganicaController.getUnidadOrganicaById);

// POST a new UnidadOrganica
router.post('/', UnidadOrganicaController.createUnidadOrganica);

// PUT update an existing UnidadOrganica
router.put('/update/:id', UnidadOrganicaController.updateUnidadOrganica);

// DELETE an existing UnidadOrganica
// muy probable no considerar esta opción
// router.delete('/:id', UnidadOrganicaController.deleteUnidadOrganica);

module.exports = router;
