const express = require('express');
const router = express.Router();
const UsuarioController = require('../controllers/usuario.controller');

// GET all Usuarios
router.get('/', UsuarioController.getAllUsuarios);

// GET Usuario by id
router.get('/:id', UsuarioController.getUsuarioById);

// POST a new Usuario
router.post('/', UsuarioController.createUsuario);

// PUT update an existing Usuario
router.put('/update/:id', UsuarioController.updateUsuario);

// DELETE an existing Usuario
// muy probable no considerar esta opción
// router.delete('/:id', UsuarioController.deleteUsuario);

// para los filtros de Usuario
// para filtrar los usuarios de tal rol
router.get('/search/rol/:elrol', UsuarioController.getrolUsuario);

// para filtrar los usuarios de tal condicion o estado
router.get('/search/sede/:elestado', UsuarioController.getestadoUsuario);

// para buscar por login correo
router.get('/loginemail/:correo/:contra', UsuarioController.getUsuarioByLoginEmail);

// para buscar por login celular
router.get('/logincelu/:celular/:contra', UsuarioController.getUsuarioByLoginPhone);

// buscar por cooreo
router.get('/search/correo/:correo', UsuarioController.getUsuarioByEmail);

// buscar por celular
router.get('/search/celu/:celular', UsuarioController.getUsuarioByPhone);

// para filtrar la verificacion de cambio de contraseña
router.get('/verification/:codigo/:id', UsuarioController.getUsuarioByRecoverContra);

// patch update para solo actualizar la contra
router.patch('/actualizar/:id', UsuarioController.updateUsuarioContra);

module.exports = router;
