const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const StateContStateler = {
  async createState(req, res) {
    try {
      const { Name } = req.body;
      const estado = await prisma.state.create(
        { data: { Name } }
      );
      res.json(
        {
          status: 'success',
          msj: 'State creada correctamente',
          data: estado
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la State',
          err: error
        }
      );
    }
  },

  async getAllStates(req, res) {
    try {
      const estados = await prisma.state.findMany();
      if (estados.length > 0) {
        res.json(
          {
            status: 'success',
            msj: 'Lista de States',
            data: estados
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No hay States registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de States',
          err: error
        }
      );
    }
  },

  async getStateById(req, res) {
    try {
      const { id } = req.params;
      const estado = await prisma.state.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (estado !== null) {
        res.json(
          {
            status: 'success',
            msj: 'State encontrada',
            data: estado
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            msj: 'No existe la State con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la State',
          err: error
        }
      );
    }
  },

  async updateState(req, res) {
    try {
      const { id } = req.params;
      const { Name } = req.body;
      const estado = await prisma.state.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Name }
        }
      );
      res.json(
        {
          status: 'success',
          msj: 'State actualizada correctamente',
          data: estado
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la State',
          err: error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una State
  // async deleteState(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.state.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'warning',
  //         msj: 'State eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la State',
  //         err: error
  //       }
  //     );
  //   }
  // }
}

module.exports = StateContStateler;
