const express = require('express');
const router = express.Router();
const AuditoriaController = require('../controllers/auditoria.controller');

// GET all Auditorias
router.get('/', AuditoriaController.getAllAuditorias);

// GET Auditoria by id
router.get('/:id', AuditoriaController.getAuditoriaById);

// POST a new Auditoria
router.post('/create', AuditoriaController.createAuditoria);

// PUT update an existing Auditoria
router.put('/update/:id', AuditoriaController.updateAuditoria);

// DELETE an existing Auditoria
// muy probable no considerar esta opción
// router.delete('/:id', AuditoriaController.deleteAuditoria);

// para los filtros de Auditoria por usuario
router.get('/usuario/:codigo', AuditoriaController.usuarioAuditoria);

// para los filtros de Auditoria por registro
router.get('/registro/:codigo', AuditoriaController.usuarioAuditoria);

module.exports = router;
