const express = require('express');
const router = express.Router();
const StateController = require('../controllers/estado.controller');

// GET all States
router.get('/', StateController.getAllStates);

// GET State by id
router.get('/:id', StateController.getStateById);

// POST a new State
router.post('/', StateController.createState);

// PUT update an existing State
router.put('/update/:id', StateController.updateState);

// DELETE an existing State
// muy probable no considerar esta opción
// router.delete('/:id', StateController.deleteState);

module.exports = router;
