const express = require('express');
const router = express.Router();
const HistoriaDepuradaController = require('../controllers/historiadepurada.controller');

// GET all Historias
router.get('/', HistoriaDepuradaController.getAllHistorias);

// GET Historia by id
router.get('/:id', HistoriaDepuradaController.getHistoriaById);

// POST a new Historia
router.post('/', HistoriaDepuradaController.createHistoria);

// PUT update an existing Historia
router.put('/update/:id', HistoriaDepuradaController.updateHistoria);

// DELETE an existing Historia
// muy probable no considerar esta opción
// router.delete('/:id', HistoriaDepuradaController.deleteHistoria);

// para los filtros por tipo
router.get('/numero/:codigo', HistoriaDepuradaController.getHistoriaByNumero);

module.exports = router;
