const express = require('express');
const router = express.Router();
const HistoriaFedateadaController = require('../controllers/historiafedateada.controller');

// GET all Historias
router.get('/', HistoriaFedateadaController.getAllHistorias);

// GET Historia by id
router.get('/:id', HistoriaFedateadaController.getHistoriaById);

// POST a new Historia
router.post('/', HistoriaFedateadaController.createHistoria);

// PUT update an existing Historia
router.put('/update/:id', HistoriaFedateadaController.updateHistoria);

// DELETE an existing Historia
// muy probable no considerar esta opción
// router.delete('/:id', HistoriaFedateadaController.deleteHistoria);

// para los filtros por tipo
router.get('/numero/:codigo', HistoriaFedateadaController.getHistoriaByNumero);

module.exports = router;
