const express = require('express');
const router = express.Router();
const HistoriaIncautadaController = require('../controllers/historiaincautada.controller');

// GET all Historias
router.get('/', HistoriaIncautadaController.getAllHistorias);

// GET Historia by id
router.get('/:id', HistoriaIncautadaController.getHistoriaById);

// POST a new Historia
router.post('/', HistoriaIncautadaController.createHistoria);

// PUT update an existing Historia
router.put('/update/:id', HistoriaIncautadaController.updateHistoria);

// DELETE an existing Historia
// muy probable no considerar esta opción
// router.delete('/:id', HistoriaIncautadaController.deleteHistoria);

// para los filtros por numero historia
router.get('/numero/:codigo', HistoriaIncautadaController.getHistoriaByNumero);

// para los filtros por apellidos
router.get('/numero/:codigo', HistoriaIncautadaController.getHistoriaByNumero);

module.exports = router;
