const express = require('express');
const router = express.Router();
const RolController = require('../controllers/rol.controller');

// GET all Rols
router.get('/', RolController.getAllRols);

// GET Rol by id
router.get('/:id', RolController.getRolById);

// POST a new Rol
router.post('/', RolController.createRol);

// PUT update an existing Rol
router.put('/update/:id', RolController.updateRol);

// DELETE an existing Rol
// muy probable no considerar esta opción
// router.delete('/:id', RolController.deleteRol);

module.exports = router;
